function [seq,seqC,score,sig,cellid]= mmbasecallcellbcintensity(intensitythresh,gaussrad)
%basecall barcoded cells based on whole cell intensity

%% 

if ~exist('intensitythresh','var')
    intensitythresh=[100 100 100 100];
end

if ~exist('gaussrad','var')
    gaussrad=0;
elseif isempty(gaussrad)
    gaussrad=0;
end
%% read 1st cycle and find BC signal
extract_aligned_image(,'MAX_Pos3_004_005');

cd aligned
seqfiles=dir(fullfile('*BC*seq*.tif')); %find all BC sequencing images
[seqfiles,~]=sort_nat({seqfiles.name}); %sort files

 lim=imread(seqfiles{1},1); %read the images
 for n=2:4
     lim(:,:,n)=imread(seqfiles{1},n);
 end

if gaussrad~=0
    lim=imgaussfilt(lim,gaussrad);
end


im=lim;

%% 
%%functions 


function extract_aligned_img(folder,filename)
warning('off', 'MATLAB:MKDIR:DirectoryExists');

zip_name=fullfile(folder,'aligned.zip');
file_name=fullfile(folder,'aligned',filename);
output_file_name=file_name;

if ~exist(output_file_name,'file')
    mkdir(fullfile(folder,'aligned'));
    unzip_file(zip_name,file_name,output_file_name)
end
warning('on', 'MATLAB:MKDIR:DirectoryExists');


